//
//  DSNotificationOperation.h
//  Courier
//
//  Created by Keith Duncan on 24/02/2011.
//  Copyright 2011 Realmac Software. All rights reserved.
//

#import <Cocoa/Cocoa.h>

/*!
	\brief
	Doesn't go isReady until the notification is received, this allows other operations to leapfrog this operation in an NSOperationQueue with a maxConcurrentOperationCount of 1.
	
	\detail
	The notification block is invoked in -main.
 */
@interface RMNotificationDependency : NSOperation

+ (id)dependencyForName:(NSString *)name object:(id)object usingBlock:(void (^)(NSNotification *))block;

- (id)initWithName:(NSString *)name object:(id)object usingBlock:(void (^)(NSNotification *))block;

@end
